package gov.va.med.domain.service.messaging.encode.hl7.util;

import ca.uhn.hl7v2.HL7Exception;

public class RdfField 
{ 
    private String _name;
    private String _type;
    private String _length;
    
    private String checkString(String value)
    throws HL7Exception
    {
        if (value == null)
           throw new HL7Exception("Null value is not permitted in field definition");
        String result=value.trim();
        if (result.length()==0)
            throw new HL7Exception("Empty value is not permitted in field definition");
        return result;
    }
    
    private String checkInteger(String value)
    throws HL7Exception
    {
        String result = checkString(value);
        
        String err = "Field length must be valid positive integer.";
        try
        {
           int i = Integer.parseInt(result);
           if (i<=0)
               throw new HL7Exception(err);
        } 
        catch (NumberFormatException e)
        {
            throw new HL7Exception(err);
        } 
        return result;
    }
    
    public RdfField(String name, String type, String length)
    throws HL7Exception
    {
        super();
        _name = checkString(name);
        _type = checkString(type);
        _length = checkInteger(length);
    }    
    
    public String getName()
    {
        return _name;
    }
    
    public String getType()
    {
        return _type;
    }
    
    public String getLength()
    {
        return _length;
    }
} 
